/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.dtmfdecoder.DecoderUtil;
import java.io.File;
import java.io.IOException;

public class TestResult {
    private String original;
    private String decoded;
    private boolean success;
    private String path;
    public int tries = 0;
    public int hits = 0;
    private double hitrate;
    public static int totalSuccess;

    public TestResult(File file, String decoded) throws IOException {
        this.path = file.getAbsolutePath();
        this.original = DecoderUtil.getFileSequence(file.getPath());
        this.decoded = decoded;
        this.success = this.original.equals(decoded);
        this.tries += this.original.length();
        this.hits += decoded.length();
    }

    public String getOriginal() {
        return this.original;
    }

    public String getDecoded() {
        return this.decoded;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public double getHitrate() {
        return this.hitrate;
    }

    public String toString() {
        this.calcHitRate();
        if (this.success) {
            return "~~ pass : , " + this.path;
        }
        return "** FAIL : , The file \"" + this.path + "\" decoded to \"" + this.decoded + "\" instead of \"" + this.original + "\"";
    }

    private void calcHitRate() {
        this.hitrate = 100.0 * (double)this.hits / ((double)this.tries * 1.0);
    }
}

